package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.FileContentDecoder;

public class CountingContentDecoder extends FilterContentDecoder {
    protected final ContentDecoderListener listener;

    protected CountingContentDecoder(
        final ContentDecoder decoder,
        final ContentDecoderListener listener)
    {
        super(decoder);
        this.listener = listener;
    }

    public static ContentDecoder wrap(
        final ContentDecoder decoder,
        final ContentDecoderListener listener)
    {
        if (decoder instanceof FileContentDecoder) {
            return new CountingFileContentDecoder(
                (FileContentDecoder) decoder,
                listener);
        } else {
            return new CountingContentDecoder(decoder, listener);
        }
    }

    @Override
    public int read(final ByteBuffer buffer) throws IOException {
        try {
            int read = super.read(buffer);
            if (read > 0) {
                listener.incrementRead(read);
            }
            return read;
        } catch (IOException e) {
            listener.onDecoderIOException(e);
            throw e;
        } catch (Throwable t) {
            listener.onDecoderError(t);
            throw t;
        }
    }
}

