package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.FileContentEncoder;

public class CountingContentEncoder extends FilterContentEncoder {
    protected final ContentEncoderListener listener;

    protected CountingContentEncoder(
        final ContentEncoder encoder,
        final ContentEncoderListener listener)
    {
        super(encoder);
        this.listener = listener;
    }

    public static ContentEncoder wrap(
        final ContentEncoder encoder,
        final ContentEncoderListener listener)
    {
        if (encoder instanceof FileContentEncoder) {
            return new CountingFileContentEncoder(
                (FileContentEncoder) encoder,
                listener);
        } else {
            return new CountingContentEncoder(encoder, listener);
        }
    }

    @Override
    public int write(final ByteBuffer buffer) throws IOException {
        try {
            int written = super.write(buffer);
            listener.incrementWritten(written);
            return written;
        } catch (IOException e) {
            listener.onEncoderIOException(e);
            throw e;
        } catch (Throwable t) {
            listener.onEncoderError(t);
            throw t;
        }
    }

    @Override
    public void complete() throws IOException {
        try {
            super.complete();
        } catch (IOException e) {
            listener.onEncoderIOException(e);
            throw e;
        } catch (Throwable t) {
            listener.onEncoderError(t);
            throw t;
        }
    }
}

