package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.channels.FileChannel;

import org.apache.http.nio.FileContentDecoder;

public class CountingFileContentDecoder extends CountingContentDecoder
    implements FileContentDecoder
{
    private final FileContentDecoder decoder;

    protected CountingFileContentDecoder(
        final FileContentDecoder decoder,
        final ContentDecoderListener listener)
    {
        super(decoder, listener);
        this.decoder = decoder;
    }

    @Override
    public long transfer(
        final FileChannel channel,
        final long position,
        final long count)
        throws IOException
    {
        try {
            long transferred = decoder.transfer(channel, position, count);
            if (transferred > 0L) {
                listener.incrementRead(transferred);
            }
            return transferred;
        } catch (IOException e) {
            listener.onDecoderIOException(e);
            throw e;
        } catch (Throwable t) {
            listener.onDecoderError(t);
            throw t;
        }
    }
}

