package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.channels.FileChannel;

import org.apache.http.nio.FileContentEncoder;

public class CountingFileContentEncoder extends CountingContentEncoder
    implements FileContentEncoder
{
    private final FileContentEncoder encoder;

    protected CountingFileContentEncoder(
        final FileContentEncoder encoder,
        final ContentEncoderListener listener)
    {
        super(encoder, listener);
        this.encoder = encoder;
    }

    @Override
    public long transfer(
        final FileChannel channel,
        final long position,
        final long count)
        throws IOException
    {
        try {
            long transferred = encoder.transfer(channel, position, count);
            listener.incrementWritten(transferred);
            return transferred;
        } catch (IOException e) {
            listener.onEncoderIOException(e);
            throw e;
        } catch (Throwable t) {
            listener.onEncoderError(t);
            throw t;
        }
    }
}

