package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;

public abstract class DevNullAsyncConsumer<T> extends AsyncConsumer<T> {
    private static final int BUFFER_SIZE = 8192;
    private static final byte[] BUF = new byte[BUFFER_SIZE];

    private final ByteBuffer buf = ByteBuffer.wrap(BUF);

    @Override
    public void consumeContent(
        final ContentDecoder decoder,
        final IOControl ioctrl)
        throws IOException
    {
        while (true) {
            buf.clear();
            if (decoder.read(buf) <= 0) {
                break;
            }
        }
    }
}

