package ru.yandex.http.util.nio;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

public class EmptyAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Void>
{
    public static final EmptyAsyncConsumerFactory INSTANCE =
        new EmptyAsyncConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<Void> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<Void>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<Void>
        NON_FATAL = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.NON_FATAL,
            INSTANCE);

    protected EmptyAsyncConsumerFactory() {
    }

    @Override
    public EmptyAsyncConsumer<Void> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new EmptyAsyncConsumer<>();
    }
}

