package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class EmptyAsyncResponseConsumer<T>
    implements HttpAsyncResponseConsumer<T>
{
    private Exception e = null;

    @Override
    public void close() {
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void responseReceived(final HttpResponse response)
        throws HttpException, IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void consumeContent(
        final ContentDecoder decoder,
        final IOControl ioctrl)
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void responseCompleted(final HttpContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void failed(final Exception e) {
        this.e = e;
    }

    @Override
    public Exception getException() {
        return e;
    }

    @Override
    public T getResult() {
        return null;
    }

    @Override
    public boolean isDone() {
        return e != null;
    }
}

