package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;

import ru.yandex.function.VoidProcessor;
import ru.yandex.http.util.EmptyHttpEntity;

public class EmptyNHttpEntity
    extends EmptyHttpEntity
    implements EntityGenerator, HttpAsyncContentProducer
{
    public static final EmptyNHttpEntity INSTANCE = new EmptyNHttpEntity();

    protected EmptyNHttpEntity() {
    }

    // EntityGenerator implementation
    @Override
    public EmptyNHttpEntity get() {
        return INSTANCE;
    }

    @Override
    public int expectedLength() {
        return 0;
    }

    @Override
    public <E extends Exception> void appendTo(
        final VoidProcessor<? super byte[], E> processor)
    {
    }

    // HttpAsyncContentProducer implementation
    @Override
    public void close() {
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioctrl)
        throws IOException
    {
        encoder.complete();
    }
}

