package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class FilterAsyncRequestProducer implements HttpAsyncRequestProducer {
    private final HttpAsyncRequestProducer producer;

    public FilterAsyncRequestProducer(
        final HttpAsyncRequestProducer producer)
    {
        this.producer = producer;
    }

    @Override
    public void close() throws IOException {
        producer.close();
    }

    @Override
    public void failed(final Exception e) {
        producer.failed(e);
    }

    @Override
    public HttpRequest generateRequest() throws HttpException, IOException {
        return producer.generateRequest();
    }

    @Override
    public HttpHost getTarget() {
        return producer.getTarget();
    }

    @Override
    public boolean isRepeatable() {
        return producer.isRepeatable();
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioctrl)
        throws IOException
    {
        producer.produceContent(encoder, ioctrl);
    }

    @Override
    public void requestCompleted(final HttpContext context) {
        producer.requestCompleted(context);
    }

    @Override
    public void resetRequest() throws IOException {
        producer.resetRequest();
    }

    @Override
    public String toString() {
        return producer.toString();
    }
}

