package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.http.nio.ContentDecoder;

public class FilterContentDecoder implements ContentDecoder {
    private final ContentDecoder decoder;

    public FilterContentDecoder(final ContentDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public int read(final ByteBuffer buffer) throws IOException {
        return decoder.read(buffer);
    }

    @Override
    public boolean isCompleted() {
        return decoder.isCompleted();
    }
}

