package ru.yandex.http.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.http.nio.ContentEncoder;

public class FilterContentEncoder implements ContentEncoder {
    private final ContentEncoder encoder;

    public FilterContentEncoder(final ContentEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public int write(final ByteBuffer buffer) throws IOException {
        return encoder.write(buffer);
    }

    @Override
    public void complete() throws IOException {
        encoder.complete();
    }

    @Override
    public boolean isCompleted() {
        return encoder.isCompleted();
    }
}

