package ru.yandex.http.util.nio;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;

public class FilterHttpAsyncExchange implements HttpAsyncExchange {
    protected final HttpAsyncExchange exchange;

    public FilterHttpAsyncExchange(final HttpAsyncExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public HttpRequest getRequest() {
        return exchange.getRequest();
    }

    @Override
    public HttpResponse getResponse() {
        return exchange.getResponse();
    }

    @Override
    public void submitResponse() {
        exchange.submitResponse();
    }

    @Override
    public void submitResponse(final HttpAsyncResponseProducer producer) {
        exchange.submitResponse(producer);
    }

    @Override
    public boolean isCompleted() {
        return exchange.isCompleted();
    }

    @Override
    public void setCallback(final Cancellable cancellable) {
        exchange.setCallback(cancellable);
    }

    @Override
    public void setTimeout(final int timeout) {
        exchange.setTimeout(timeout);
    }

    @Override
    public int getTimeout() {
        return exchange.getTimeout();
    }
}
