package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.protocol.HttpContext;

public class FilterNHttpClientConnection implements NHttpClientConnection {
    protected final NHttpClientConnection conn;

    public FilterNHttpClientConnection(final NHttpClientConnection conn) {
        this.conn = conn;
    }

    // HttpConnection implementation
    @Override
    public void close() throws IOException {
        conn.close();
    }

    @Override
    public boolean isOpen() {
        return conn.isOpen();
    }

    @Override
    public boolean isStale() {
        return conn.isStale();
    }

    @Override
    public void setSocketTimeout(final int timeout) {
        conn.setSocketTimeout(timeout);
    }

    @Override
    public int getSocketTimeout() {
        return conn.getSocketTimeout();
    }

    @Override
    public void shutdown() throws IOException {
        conn.shutdown();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return conn.getMetrics();
    }

    // IOControl implementation
    @Override
    public void requestInput() {
        conn.requestInput();
    }

    @Override
    public void suspendInput() {
        conn.suspendInput();
    }

    @Override
    public void requestOutput() {
        conn.requestOutput();
    }

    @Override
    public void suspendOutput() {
        conn.suspendOutput();
    }

    // NHttpConnection implementation
    @Override
    public int getStatus() {
        return conn.getStatus();
    }

    @Override
    public HttpRequest getHttpRequest() {
        return conn.getHttpRequest();
    }

    @Override
    public HttpResponse getHttpResponse() {
        return conn.getHttpResponse();
    }

    @Override
    public HttpContext getContext() {
        return conn.getContext();
    }

    // NHttpClientConnection implementation
    @Override
    public void submitRequest(final HttpRequest request)
        throws HttpException, IOException
    {
        conn.submitRequest(request);
    }

    @Override
    public boolean isRequestSubmitted() {
        return conn.isRequestSubmitted();
    }

    @Override
    public void resetOutput() {
        conn.resetOutput();
    }

    @Override
    public void resetInput() {
        conn.resetInput();
    }
}

