package ru.yandex.http.util.nio;

import java.io.IOException;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class HeaderAsyncRequestProducer extends FilterAsyncRequestProducer {
    private final List<Header> headers;

    public HeaderAsyncRequestProducer(
        final HttpAsyncRequestProducer producer,
        final List<Header> headers)
    {
        super(producer);
        this.headers = headers;
    }

    @Override
    public HttpRequest generateRequest() throws HttpException, IOException {
        HttpRequest request = super.generateRequest();
        for (Header header: headers) {
            if (request.getFirstHeader(header.getName()) == null) {
                request.addHeader(header);
            }
        }
        return request;
    }
}

