package ru.yandex.http.util.nio;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

import org.apache.http.Header;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class HeaderAsyncRequestProducerSupplier
    implements Supplier<HttpAsyncRequestProducer>
{
    private final Supplier<HttpAsyncRequestProducer> supplier;
    private final List<Header> headers;

    public HeaderAsyncRequestProducerSupplier(
        final Supplier<HttpAsyncRequestProducer> supplier,
        final Header... headers)
    {
        this(supplier, Arrays.asList(headers));
    }

    public HeaderAsyncRequestProducerSupplier(
        final Supplier<HttpAsyncRequestProducer> supplier,
        final List<Header> headers)
    {
        this.supplier = supplier;
        this.headers = headers;
    }

    @Override
    public HttpAsyncRequestProducer get() {
        return new HeaderAsyncRequestProducer(supplier.get(), headers);
    }
}

