package ru.yandex.http.util.nio;

import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.collection.IntPair;

public class IntPairAsyncResponseConsumer<T>
    extends AbstractFilterAsyncResponseConsumer<T>
    implements HttpAsyncResponseConsumer<IntPair<T>>
{
    private final int value;

    public IntPairAsyncResponseConsumer(
        final int value,
        final HttpAsyncResponseConsumer<? extends T> consumer)
    {
        super(consumer);
        this.value = value;
    }

    @Override
    public IntPair<T> getResult() {
        return new IntPair<>(value, consumer.getResult());
    }
}

