package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class LazyAsyncResponseConsumer<T>
    extends FilterAsyncResponseConsumer<T>
{
    private final HttpAsyncResponseConsumerFactory<T> factory;
    private final HttpAsyncRequestProducer producer;

    public LazyAsyncResponseConsumer(
        final HttpAsyncResponseConsumerFactory<T> factory,
        final HttpAsyncRequestProducer producer)
    {
        super(new EmptyAsyncResponseConsumer<T>());
        this.factory = factory;
        this.producer = producer;
    }

    @Override
    public void responseReceived(final HttpResponse response)
        throws HttpException, IOException
    {
        consumer = factory.create(producer, response);
        super.responseReceived(response);
    }
}

