package ru.yandex.http.util.nio;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.nio.reactor.IOReactorExceptionHandler;

public class LoggingIOReactorExceptionHandler
    implements IOReactorExceptionHandler
{
    private final Logger logger;

    public LoggingIOReactorExceptionHandler(final Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean handle(final IOException e) {
        logger.log(Level.WARNING, "I/O error in reactor", e);
        return true;
    }

    @Override
    public boolean handle(final RuntimeException e) {
        logger.log(Level.SEVERE, "Something weird happened in reactor", e);
        return true;
    }
}

