package ru.yandex.http.util.nio;

import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.collection.LongPair;

public class LongPairAsyncResponseConsumer<T>
    extends AbstractFilterAsyncResponseConsumer<T>
    implements HttpAsyncResponseConsumer<LongPair<T>>
{
    private final long value;

    public LongPairAsyncResponseConsumer(
        final long value,
        final HttpAsyncResponseConsumer<? extends T> consumer)
    {
        super(consumer);
        this.value = value;
    }

    @Override
    public LongPair<T> getResult() {
        return new LongPair<>(value, consumer.getResult());
    }
}

