package ru.yandex.http.util.nio;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

public enum NByteArrayEntityAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<HttpEntity>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<HttpEntity>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);
    public static final StatusCheckAsyncResponseConsumerFactory<HttpEntity>
        ANY_GOOD = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.ANY_GOOD,
            INSTANCE);

    @Override
    public NByteArrayEntityAsyncConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
    {
        return new NByteArrayEntityAsyncConsumer();
    }
}

