package ru.yandex.http.util.nio;

import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.function.ByteArrayProcessor;

public class NByteArrayEntityFactory
    implements ByteArrayProcessor<NByteArrayEntity, RuntimeException>
{
    public static final NByteArrayEntityFactory INSTANCE =
        new NByteArrayEntityFactory();

    private final ContentType contentType;

    protected NByteArrayEntityFactory() {
        this(null);
    }

    public NByteArrayEntityFactory(final ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public NByteArrayEntity process(
        final byte[] buf,
        final int off,
        final int len)
    {
        return new NByteArrayEntity(buf, off, len, contentType);
    }
}

