package ru.yandex.http.util.nio;

import org.apache.http.HttpEntity;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.VoidProcessor;

public class NByteArrayEntityGeneratorAsyncConsumer
    extends AbstractAsyncByteArrayConsumer<EntityGenerator>
{
    @Override
    protected EntityGenerator buildResult(
        final HttpContext context)
        throws Exception
    {
        if (buf == null) {
            return EmptyNHttpEntity.INSTANCE;
        } else {
            return new Generator(this);
        }
    }

    private static class Generator extends AbstractEntityGenerator {
        private final byte[] buf;
        private final int len;

        Generator(final NByteArrayEntityGeneratorAsyncConsumer consumer) {
            super(consumer.contentTypeHeader, consumer.contentEncodingHeader);
            buf = consumer.buf;
            len = consumer.len;
        }

        @Override
        public HttpEntity get() {
            return adjustEntity(new NByteArrayEntity(buf, 0, len));
        }

        @Override
        protected int expectedBodyLength() {
            return len << 1;
        }

        @Override
        protected <E extends Exception> void appendBody(
            final VoidProcessor<? super byte[], E> processor)
            throws E
        {
            appendLf(processor);
            processor.process(buf, 0, len);
        }
    }
}

