package ru.yandex.http.util.nio;

import java.io.File;
import java.nio.charset.StandardCharsets;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NFileEntity;

import ru.yandex.function.VoidProcessor;

public class NFileEntityGenerator extends AbstractEntityGenerator {
    private static final String PREFIX = "\nFILE ENTITY: ";

    private final File file;

    public NFileEntityGenerator(
        final File file,
        final ContentType contentType)
    {
        this(file, contentType, null);
    }

    public NFileEntityGenerator(
        final File file,
        final ContentType contentType,
        final Header contentEncoding)
    {
        this(file, contentType(contentType), contentEncoding);
    }

    public NFileEntityGenerator(
        final File file,
        final Header contentType,
        final Header contentEncoding)
    {
        super(contentType, contentEncoding);
        this.file = file;
    }

    @Override
    public HttpEntity get() {
        return adjustEntity(new NFileEntity(file));
    }

    @Override
    protected int expectedBodyLength() {
        return PREFIX.length() + file.getPath().length();
    }

    @Override
    protected <E extends Exception> void appendBody(
        final VoidProcessor<? super byte[], E> processor)
        throws E
    {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        sb.append(file.getPath());
        processor.process(new String(sb).getBytes(StandardCharsets.UTF_8));
    }
}

