package ru.yandex.http.util.nio;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ExceptionEvent;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class ReactorUtils {
    private static final DateTimeFormatter DATE_FORMATTER =
        DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS");

    private ReactorUtils() {
    }

    @SuppressWarnings("JdkObsolete")
    public static void status(
        final Map<String, Object> status,
        final AbstractMultiworkerIOReactor reactor)
    {
        status.put("status", reactor.getStatus());
        List<ExceptionEvent> events = reactor.getAuditLog();
        if (events != null && !events.isEmpty()) {
            Map<Object, Object> exceptions = new LinkedHashMap<>();
            for (ExceptionEvent event: events) {
                exceptions.put(
                    new IdentityObject(
                        DATE_FORMATTER.print(event.getTimestamp().getTime())),
                    event.getCause());
            }
            status.put("exceptions", exceptions);
        }
    }

    private static class IdentityObject {
        private final Object object;

        IdentityObject(final Object object) {
            this.object = object;
        }

        @Override
        public int hashCode() {
            return object.hashCode();
        }

        @Override
        public boolean equals(final Object o) {
            return this == o;
        }

        @Override
        public String toString() {
            return object.toString();
        }
    }
}

