package ru.yandex.http.util.nio;

import java.io.IOException;
import java.util.function.IntPredicate;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

public class StatusCheckAsyncResponseConsumerFactory<T>
    implements HttpAsyncResponseConsumerFactory<T>
{
    private final IntPredicate statusChecker;
    private final HttpAsyncResponseConsumerFactory<T> nextConsumerFactory;

    public StatusCheckAsyncResponseConsumerFactory(
        final IntPredicate statusChecker,
        final HttpAsyncResponseConsumerFactory<T> nextConsumerFactory)
    {
        this.statusChecker = statusChecker;
        this.nextConsumerFactory = nextConsumerFactory;
    }

    @Override
    public HttpAsyncResponseConsumer<T> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        if (statusChecker.test(response.getStatusLine().getStatusCode())) {
            return nextConsumerFactory.create(producer, response);
        } else {
            return new BadResponseExceptionAsyncConsumer<>(producer, response);
        }
    }
}

