package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.collection.IntPair;
import ru.yandex.http.util.HttpStatusPredicates;

public class StatusCodeAsyncConsumerFactory<T>
    implements HttpAsyncResponseConsumerFactory<IntPair<T>>
{
    public static final StatusCheckAsyncResponseConsumerFactory<IntPair<Void>>
        ANY_GOOD =
            new StatusCheckAsyncResponseConsumerFactory<>(
                HttpStatusPredicates.ANY_GOOD,
                new StatusCodeAsyncConsumerFactory<>(
                    EmptyAsyncConsumerFactory.INSTANCE));

    private final HttpAsyncResponseConsumerFactory<? extends T> factory;

    public StatusCodeAsyncConsumerFactory(
        final HttpAsyncResponseConsumerFactory<? extends T> factory)
    {
        this.factory = factory;
    }

    @Override
    public IntPairAsyncResponseConsumer<T> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new IntPairAsyncResponseConsumer<>(
            response.getStatusLine().getStatusCode(),
            factory.create(producer, response));
    }
}

