package ru.yandex.http.util.nio;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.apache.http.protocol.HttpContext;

import ru.yandex.compress.GzipInputStream;
import ru.yandex.compress.InflaterInputStream;
import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.function.Processable;
import ru.yandex.io.DecodableByteArrayOutputStream;

public class UngzippingByteArrayProcessableAsyncConsumer
        extends AbstractAsyncByteArrayConsumer<Processable<byte[]>> {
    @Override
    protected Processable<byte[]> buildResult(final HttpContext context) throws IOException {
        if (buf == null) {
            return new ByteArrayProcessable();
        } else {
            if (contentEncodingHeader != null
                    && "gzip".equals(contentEncodingHeader.getValue())) {
                DecodableByteArrayOutputStream outputStream =
                        new DecodableByteArrayOutputStream();
                try (InflaterInputStream inputStream =
                             new GzipInputStream(
                                     new ByteArrayInputStream(buf, 0, len))) {
                    inputStream.transferTo(outputStream);
                }
                return outputStream;
            } else {
                return new ByteArrayProcessable(buf, 0, len);
            }
        }
    }
}
