package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.function.Processable;
import ru.yandex.http.util.HttpStatusPredicates;

public class UngzippingByteArrayProcessableAsyncConsumerFactory implements HttpAsyncResponseConsumerFactory<Processable<byte[]>> {
    public static final UngzippingByteArrayProcessableAsyncConsumerFactory INSTANCE =
            new UngzippingByteArrayProcessableAsyncConsumerFactory();

    public static final StatusCheckAsyncResponseConsumerFactory<Processable<byte[]>>
            OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);


    public static final StatusCheckAsyncResponseConsumerFactory<Processable<byte[]>>
            NON_FATAL = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.NON_FATAL,
            INSTANCE);

    @Override
    public HttpAsyncResponseConsumer<Processable<byte[]>> create(HttpAsyncRequestProducer producer,
                                                                 HttpResponse response) throws HttpException,
            IOException {
        return new UngzippingByteArrayProcessableAsyncConsumer();
    }
}
