package ru.yandex.http.util.nio;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.collection.LongPair;
import ru.yandex.http.util.BadGatewayException;
import ru.yandex.http.util.YandexHeaders;

public class ZooQueueIdAsyncConsumerFactory<T>
    implements HttpAsyncResponseConsumerFactory<LongPair<T>>
{
    private final HttpAsyncResponseConsumerFactory<? extends T> factory;

    public ZooQueueIdAsyncConsumerFactory(
        final HttpAsyncResponseConsumerFactory<? extends T> factory)
    {
        this.factory = factory;
    }

    @Override
    public LongPairAsyncResponseConsumer<T> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new LongPairAsyncResponseConsumer<>(
            parseZooQueueId(response),
            factory.create(producer, response));
    }

    private static long parseZooQueueId(final HttpResponse response)
        throws HttpException
    {
        long zooQueueId = Integer.MIN_VALUE;
        Header header = response.getFirstHeader(YandexHeaders.ZOO_QUEUE_ID);
        if (header != null) {
            try {
                zooQueueId = Long.parseLong(header.getValue());
            } catch (NullPointerException | NumberFormatException e) {
                throw new BadGatewayException(e);
            }
        }
        return zooQueueId;
    }
}

