package ru.yandex.http.proxy;

import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.HttpExceptionConverter;

public abstract class AbstractProxySessionCallback<T>
    implements FutureCallback<T>
{
    protected final ProxySession session;

    protected AbstractProxySessionCallback(final ProxySession session) {
        this.session = session;
    }

    @Override
    public void cancelled() {
        session.logger().warning(
            "Request cancelled: " + session.listener().details());
    }

    @Override
    public void failed(final Exception e) {
        String details = session.listener().details();
        session.logger().log(
            Level.WARNING,
            "Request failed: " + details + " because of",
            e);
        HttpException ex = HttpExceptionConverter.toHttpException(e);
        ex.addSuppressed(new Exception(details));
        session.handleException(ex);
    }
}

