package ru.yandex.http.proxy;

import org.apache.http.HttpStatus;

public class BasicProxySessionCallback
    extends AbstractProxySessionCallback<Object>
{
    private final int status;

    public BasicProxySessionCallback(final ProxySession session) {
        this(session, HttpStatus.SC_OK);
    }

    public BasicProxySessionCallback(
        final ProxySession session,
        final int status)
    {
        super(session);
        this.status = status;
    }

    @Override
    public void completed(final Object object) {
        session.response(status);
    }
}

