package ru.yandex.http.proxy;

import java.nio.charset.Charset;
import java.util.Set;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.util.FilterCancellationSubscriber;
import ru.yandex.http.util.HeadersParser;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

public class FilterProxySession
    extends FilterCancellationSubscriber
    implements ProxySession
{
    protected final ProxySession session;

    public FilterProxySession(final ProxySession session) {
        super(session);
        this.session = session;
    }

    // ProxySession implementation
    @Override
    public Charset acceptedCharset() {
        return session.acceptedCharset();
    }

    @Override
    public HttpRequest request() {
        return session.request();
    }

    @Override
    public UriParser uri() {
        return session.uri();
    }

    @Override
    public CgiParams params() {
        return session.params();
    }

    @Override
    public HeadersParser headers() {
        return session.headers();
    }

    @Override
    public HttpCoreContext context() {
        return session.context();
    }

    @Override
    public HttpAsyncExchange exchange() {
        return session.exchange();
    }

    @Override
    public PrefixedLogger logger() {
        return session.logger();
    }

    @Override
    public RequestsListener listener() {
        return session.listener();
    }

    @Override
    public LoggingServerConnection connection() {
        return session.connection();
    }

    @Override
    public Set<String> debugFlags() {
        return session.debugFlags();
    }

    @Override
    public HttpResponse getResponse() {
        return session.getResponse();
    }

    @Override
    public void response(final int status) {
        session.response(status);
    }

    @Override
    public void response(final int status, final String body) {
        session.response(status, body);
    }

    @Override
    public void response(final int status, final HttpEntity entity) {
        session.response(status, entity);
    }

    @Override
    public void response(final HttpResponse response) {
        session.response(response);
    }

    @Override
    public void response(final HttpAsyncResponseProducer producer) {
        session.response(producer);
    }

    @Override
    public void handleException(final HttpException e) {
        session.handleException(e);
    }
}

