package ru.yandex.http.proxy;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import ru.yandex.http.util.YandexHeaders;

public class HttpProxyTvm2HeaderSupplier implements Supplier<List<Header>> {
    private final List<Map.Entry<String, String>> headerDests;
    private final MultiClientTvm2TicketSupplier tvm2TicketSupplier;

    public HttpProxyTvm2HeaderSupplier(
        final MultiClientTvm2TicketSupplier tvm2TicketSupplier,
        final String destId)
    {
        this(
            tvm2TicketSupplier,
            Collections.singletonList(
                new AbstractMap.SimpleImmutableEntry<>(
                    YandexHeaders.X_YA_SERVICE_TICKET,
                    destId)));
    }

    public HttpProxyTvm2HeaderSupplier(
        final MultiClientTvm2TicketSupplier tvm2TicketSupplier,
        final List<Map.Entry<String, String>> headersWithIds)
    {
        this.headerDests = headersWithIds;
        this.tvm2TicketSupplier = tvm2TicketSupplier;

        for (Map.Entry<String, String> entry: headersWithIds) {
            tvm2TicketSupplier.addDestId(entry.getValue());
        }
    }

    @Override
    public List<Header> get() {
        if (headerDests.size() == 1) {
            Map.Entry<String, String> entry = headerDests.get(0);
            return Collections.singletonList(
                new BasicHeader(
                    entry.getKey(),
                    tvm2TicketSupplier.ticket(entry.getValue())));
        } else {
            List<Header> headers = new ArrayList<>(headerDests.size());
            for (Map.Entry<String, String> entry: headerDests) {
                headers.add(
                    new BasicHeader(
                        entry.getKey(),
                        tvm2TicketSupplier.ticket(entry.getValue())));
            }

            return headers;
        }
    }
}
