package ru.yandex.http.proxy;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.server.async.BaseAsyncServer;

public class OpenApiProxyRequestHandlerAdapter
    extends ProxyRequestHandlerAdapter
{
    private final ProxyRequestHandler handler;
    private final BaseAsyncServer<?> server;

    public OpenApiProxyRequestHandlerAdapter(
        final ProxyRequestHandler handler,
        final BaseAsyncServer<?> server)
    {
        super(handler, server);

        this.server = server;
        this.handler = handler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        handler.handle(new OpenApiProxySession(server, exchange, context));
    }
}
