package ru.yandex.http.proxy;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;

import ru.yandex.http.server.async.BaseAsyncServer;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ByteArrayEntityFactory;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.HeadersParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.OpenApiCgiParams;

public class OpenApiProxySession extends BasicProxySession {
    @SuppressWarnings("HidingField")
    private final HttpRequest request;
    private final OpenApiCgiParams params;

    public OpenApiProxySession(
        final BaseAsyncServer<?> server,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        this(server, exchange, HttpCoreContext.adapt(context));
    }

    public OpenApiProxySession(
        final BaseAsyncServer<?> server,
        final HttpAsyncExchange exchange,
        final HttpCoreContext context)
        throws HttpException
    {
        super(server, exchange, context);

        HttpRequest request = exchange.getRequest();

        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            HttpRequest clonedRequest;
            try {
                ByteArrayEntity clonedEntity = cloneEntity(entity);
                clonedEntity.setContentType(entity.getContentType());
                clonedEntity.setContentEncoding(entity.getContentEncoding());
                BasicHttpEntityEnclosingRequest entityRequest =
                    new BasicHttpEntityEnclosingRequest(request.getRequestLine());
                entityRequest.setEntity(clonedEntity);
                clonedRequest = entityRequest;
            } catch (IOException ioe) {
                logger().log(Level.WARNING, "OpenApi Exception on clone", ioe);
                throw new BadRequestException(ioe);
            }

            this.request = clonedRequest;
        } else {
            this.request = request;
        }

        this.params = new OpenApiCgiParams(this.request, queryParser());
    }

    private ByteArrayEntity cloneEntity(final HttpEntity entity) throws IOException {
        ByteArrayEntity newEntity = CharsetUtils.toDecodable(entity)
            .processWith(ByteArrayEntityFactory.INSTANCE);
        newEntity.setContentType(entity.getContentType());
        newEntity.setContentEncoding(entity.getContentEncoding());
        return newEntity;
    }

    @Override
    public HttpRequest request() {
        return request;
    }

    @Override
    public CgiParams params() {
        return params;
    }

    @Override
    public HeadersParser headers() {
        // TODO
        return super.headers();
    }

    @Override
    public void response(final int status, final HttpEntity entity) {
        HttpEntity newEntity = entity;
        try {
            if (entity != null) {
                newEntity = cloneEntity(entity);
                params.path().response(status, EntityUtils.toString(newEntity));
            } else {
                params.path().response(status, "");
            }
        } catch (IOException ioe) {
            logger().log(Level.WARNING, "Failed to accumulate response for OpenApi", ioe);
        }

        super.response(status, newEntity);
    }

    @Override
    public void response(final HttpAsyncResponseProducer producer) {
        // TODO
        super.response(producer);
    }
}
