package ru.yandex.http.proxy;

import ru.yandex.logger.PrefixedLogger;

public class PrefixedProxySession extends FilterProxySession {
    private final PrefixedLogger logger;

    public PrefixedProxySession(
        final ProxySession session,
        final String prefix)
    {
        super(session);
        logger = session.logger().addPrefix(prefix);
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }
}

