package ru.yandex.http.proxy;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.server.async.BaseAsyncServer;

public class ProxyRequestHandlerAdapter
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final ProxyRequestHandler handler;
    private final BaseAsyncServer<?> server;

    public ProxyRequestHandlerAdapter(
        final ProxyRequestHandler handler,
        final BaseAsyncServer<?> server)
    {
        this.handler = handler;
        this.server = server;
    }

    @Override
    public String toString() {
        return handler.toString();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        handler.handle(new BasicProxySession(server, exchange, context));
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }
}

