package ru.yandex.http.proxy;

import java.nio.charset.Charset;
import java.util.Set;

import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.util.CancellationSubscriber;
import ru.yandex.http.util.HeadersParser;
import ru.yandex.http.util.nio.BasicAsyncResponseProducer;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

public interface ProxySession
    extends CancellationSubscriber, HttpExceptionHandler
{
    Charset acceptedCharset();

    HttpRequest request();

    UriParser uri();

    CgiParams params();

    HeadersParser headers();

    HttpCoreContext context();

    HttpAsyncExchange exchange();

    PrefixedLogger logger();

    RequestsListener listener();

    LoggingServerConnection connection();

    Set<String> debugFlags();

    HttpResponse getResponse();

    default void response(int status) {
        response(status, (HttpEntity) null);
    }

    default void response(final int status, final String body) {
        response(
            status,
            new NStringEntity(
                body,
                ContentType.TEXT_PLAIN.withCharset(acceptedCharset())));
    }

    default void response(final HttpResponse response) {
        response.removeHeaders(HTTP.CONTENT_LEN);
        response.removeHeaders(HTTP.CONTENT_TYPE);
        response.removeHeaders(HTTP.CONTENT_ENCODING);
        response.removeHeaders(HTTP.CONN_DIRECTIVE);
        response.removeHeaders(HTTP.CONN_KEEP_ALIVE);
        response.removeHeaders(HTTP.TRANSFER_ENCODING);
        response(new BasicAsyncResponseProducer(response));
    }

    void response(int status, HttpEntity entity);

    void response(HttpAsyncResponseProducer producer);
}

