package ru.yandex.http.proxy;

import java.util.function.Function;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;

import ru.yandex.function.ConstFunction;

public class StaticEntitySendingCallback<T>
    extends AbstractProxySessionCallback<T>
{
    private final Function<? super T, String> resultToInfo;
    private final HttpEntity payload;
    private final int statusCode;

    public StaticEntitySendingCallback(final ProxySession session) {
        this(session, new ConstFunction<>(null), HttpStatus.SC_OK, null);
    }

    public StaticEntitySendingCallback(
        final ProxySession session,
        final int statusCode)
    {
        this(session, new ConstFunction<>(null), statusCode, null);
    }

    public StaticEntitySendingCallback(
        final ProxySession session,
        final int statusCode,
        final HttpEntity payload)
    {
        this(session, new ConstFunction<>(null), statusCode, payload);
    }

    public StaticEntitySendingCallback(
        final ProxySession session,
        final Function<? super T, String> resultToInfo)
    {
        this(session, resultToInfo, HttpStatus.SC_OK, null);
    }

    public StaticEntitySendingCallback(
        final ProxySession session,
        final Function<? super T, String> resultToInfo,
        final int statusCode,
        final HttpEntity payload)
    {
        super(session);
        this.resultToInfo = resultToInfo;
        this.statusCode = statusCode;
        this.payload = payload;
    }

    @Override
    public void completed(final T result) {
        String info = resultToInfo.apply(result);
        String message;
        if (info == null) {
            message = "Request completed";
        } else {
            message = info;
        }
        session.logger().fine(message);
        session.response(statusCode, payload);
    }
}

