package ru.yandex.http.proxy;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.http.util.nio.client.AsyncClient;

public class StaticProxyHandler implements ProxyRequestHandler {
    private final RequestProxy proxy;
    private final List<HttpHost> hosts;

    public StaticProxyHandler(final AsyncClient client, final HttpHost host) {
        this(client, Collections.singletonList(host));
    }

    public StaticProxyHandler(
        final AsyncClient client,
        final List<HttpHost> hosts)
    {
        this(new RequestProxy(client), hosts);
    }

    public StaticProxyHandler(
        final RequestProxy proxy,
        final List<HttpHost> hosts)
    {
        this.proxy = proxy;
        this.hosts = hosts;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        proxy.handle(session, hosts);
    }
}

