package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

public abstract class AbstractFilterFutureCallback<T, U>
    implements FutureCallback<T>
{
    protected final FutureCallback<? super U> callback;

    protected AbstractFilterFutureCallback(
        final FutureCallback<? super U> callback)
    {
        this.callback = callback;
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }
}

