package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

public abstract class AbstractFilterMultiFutureCallback<T, U>
    implements FutureCallback<T>
{
    protected final MultiFutureCallback<U> callback;

    protected AbstractFilterMultiFutureCallback(
        final MultiFutureCallback<U> callback)
    {
        this.callback = callback;
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }
}
