package ru.yandex.http.util;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

import ru.yandex.util.string.StringUtils;

public class BadResponseException extends ServerException {
    private static final long serialVersionUID = 0;
    private static final String WITH_BODY = " with body: ";

    private final String request;
    private final String responseHead;
    private final String responseBody;

    public BadResponseException(
        final Object request,
        final HttpResponse response)
        throws HttpException, IOException
    {
        this(
            request,
            response,
            CharsetUtils.toString(response.getEntity()).trim());
    }

    public BadResponseException(
        final Object request,
        final HttpResponse response,
        final String body)
    {
        super(response.getStatusLine().getStatusCode());
        if (request instanceof HttpRequest) {
            this.request =
                new String(
                    RequestToString.requestToStringBuilder(
                        "",
                        (HttpRequest) request,
                        0,
                        YandexHeaders.DEFAULT_HIDDEN_HEADERS));
        } else {
            this.request = request.toString();
        }
        responseHead = response.toString();
        responseBody = body;
    }

    public String request() {
        return request;
    }

    public String response() {
        if (responseBody.isEmpty()) {
            return responseHead;
        } else {
            return StringUtils.concat(responseHead, WITH_BODY, responseBody);
        }
    }

    public String getResponseBody() {
        return responseBody;
    }

    public void getShortMessage(final StringBuilder sb) {
        sb.append("Request ");
        sb.append(request);
        sb.append(" failed with ");
        sb.append(responseHead);
    }

    @Override
    public void getMessage(final StringBuilder sb) {
        getShortMessage(sb);
        if (!responseBody.isEmpty()) {
            sb.append(WITH_BODY);
            sb.append(responseBody);
        }
    }
}

