package ru.yandex.http.util;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.ExceptionLogger;

public class BasicExceptionLogger implements ExceptionLogger {
    private final Logger logger;
    private final String message;

    public BasicExceptionLogger(final Logger logger, final String message) {
        this.logger = logger;
        this.message = message;
    }

    @Override
    public void log(final Exception e) {
        logger.log(Level.WARNING, message, e);
    }
}

