package ru.yandex.http.util;

import java.io.Serializable;

import org.apache.http.FormattedHeader;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class BasicFormattedHeader
    implements Cloneable, FormattedHeader, Serializable
{
    private static final long serialVersionUID = 0L;

    private final String name;
    private final String value;
    private final int valuePos;
    private final CharArrayBuffer buffer;

    public BasicFormattedHeader(final String name, final String value) {
        this.name = name;
        valuePos = name.length() + 2;
        int len;
        if (value == null) {
            this.value = "";
            len = valuePos;
        } else {
            this.value = value;
            len = valuePos + value.length();
        }
        buffer = new CharArrayBuffer(len);
        buffer.append(name);
        buffer.append(':');
        buffer.append(' ');
        if (value != null) {
            buffer.append(value);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        cursor.updatePos(valuePos);
        return BasicHeaderValueParser.INSTANCE.parseElements(buffer, cursor);
    }

    @Override
    public int getValuePos() {
        return valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return buffer;
    }

    @Override
    public String toString() {
        return buffer.toString();
    }
}

