package ru.yandex.http.util;

import org.apache.http.Header;
import org.apache.http.entity.ContentType;

import ru.yandex.function.Processable;

public class ByteArrayProcessableWithContentType {
    private final Processable<byte[]> data;
    private final ContentType contentType;
    private final Header contentTypeHeader;
    private final Header contentEncodingHeader;

    public ByteArrayProcessableWithContentType(
        final Processable<byte[]> data,
        final ContentType contentType,
        final Header contentTypeHeader,
        final Header contentEncodingHeader)
    {
        this.data = data;
        this.contentType = contentType;
        this.contentTypeHeader = contentTypeHeader;
        this.contentEncodingHeader = contentEncodingHeader;
    }

    public Processable<byte[]> data() {
        return data;
    }

    public ContentType contentType() {
        return contentType;
    }

    public Header contentTypeHeader() {
        return contentTypeHeader;
    }

    public Header contentEncodingHeader() {
        return contentEncodingHeader;
    }
}

