package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.FutureBase;

public abstract class CallbackFutureBase<T, U>
    extends FutureBase<T>
    implements FutureCallback<U>
{
    protected final FutureCallback<? super T> callback;

    protected CallbackFutureBase(final FutureCallback<? super T> callback) {
        this.callback = callback;
    }

    protected abstract T convertResult(U result);

    @Override
    protected boolean onCancel(final boolean mayInterruptIfRunning) {
        callback.cancelled();
        return super.onCancel(mayInterruptIfRunning);
    }

    @Override
    protected void onComplete(final T result) {
        callback.completed(result);
    }

    @Override
    protected void onFailure(final Exception e) {
        callback.failed(e);
    }

    @Override
    public void completed(final U result) {
        completedInternal(convertResult(result));
    }
}

