package ru.yandex.http.util;

import java.util.concurrent.Future;

import org.apache.http.concurrent.Cancellable;

public class CancellableFutureProxy implements Cancellable {
    private final Future<?> f;

    public CancellableFutureProxy(final Future<?> f) {
        this.f = f;
    }

    @Override
    public boolean cancel() {
        return f.cancel(true);
    }

    @Override
    public int hashCode() {
        return f.hashCode();
    }

    @Override
    public boolean equals(final Object other) {
        if (other instanceof CancellableFutureProxy) {
            return f.equals(((CancellableFutureProxy) other).f);
        } else {
            return false;
        }
    }
}

