package ru.yandex.http.util;

import java.util.concurrent.Future;

import org.apache.http.concurrent.Cancellable;

public interface CancellationSubscriber {
    boolean cancelled();

    void subscribeForCancellation(Cancellable callback);

    default void subscribeForCancellation(Future<?> callback) {
        if (callback instanceof Cancellable) {
            subscribeForCancellation((Cancellable) callback);
        } else {
            subscribeForCancellation(new CancellableFutureProxy(callback));
        }
    }

    void unsubscribeFromCancellation(Cancellable callback);

    default void unsubscribeFromCancellation(Future<?> callback) {
        if (callback instanceof Cancellable) {
            unsubscribeFromCancellation((Cancellable) callback);
        } else {
            unsubscribeFromCancellation(new CancellableFutureProxy(callback));
        }
    }
}

