package ru.yandex.http.util;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericAutoCloseable;

public class ClosingFutureCallback<T> implements FutureCallback<T> {
    protected final FutureCallback<? super T> callback;
    protected final GenericAutoCloseable<RuntimeException> resource;

    public ClosingFutureCallback(
        final FutureCallback<? super T> callback,
        final GenericAutoCloseable<RuntimeException> resource)
    {
        this.callback = callback;
        this.resource = resource;
    }

    @Override
    @SuppressWarnings("try")
    public void cancelled() {
        try (GenericAutoCloseable<RuntimeException> resource = this.resource) {
            callback.cancelled();
        }
    }

    @Override
    @SuppressWarnings("try")
    public void completed(final T response) {
        try (GenericAutoCloseable<RuntimeException> resource = this.resource) {
            callback.completed(response);
        }
    }

    @Override
    @SuppressWarnings("try")
    public void failed(final Exception e) {
        try (GenericAutoCloseable<RuntimeException> resource = this.resource) {
            callback.failed(e);
        }
    }
}

